10 REM     MOUNTAIN SHADOWS
11 REM
12 DIM M(70): C=-0.4
13 DR=2*3.14159265/360: FM=1/5280
14 INPUT "MOUNTAIN HEIGHT (FT)";H1
15 INPUT "OBSERVER HEIGHT (FT)";H0
16 INPUT "HORIZON HEIGHT (FT) ";H
17 H1=H1*FM: H0=H0*FM: H=H*FM
18 INPUT "SLOPE ";S: S=S*DR
19 INPUT "SUN ALT";A: A=A*DR
20 INPUT "OBS'R AZ";Z: Z=Z*DR
21 E=0.30: B=0.005: B9=0.9+B
22 H9=60: V9=30: W=1*DR
23 S9=2.5*LOG(B9)/LOG(10)
24 S0=2.5*LOG(B)/LOG(10)
25 REM  OBSERVER'S LOCATION
26 X0=COS(Z)*(H1-H0)/TAN(S)
27 Y0=SIN(Z)*(H0-H1)/TAN(S)
28 Z0=H0-H1
29 REM  SET UP GRID OF DIRECTIONS
30 FOR J=1 TO V9
31 AL=W*(V9/2-J)
32 FOR I=1 TO H9
33 AZ=W*(I-H9/2)
34 REM  DISTANCE TO 'NORTH' SLOPE
35 REM  SHADOW PLANE
36 A0=SQR(TAN(S)^2-TAN(A)^2)
37 A1=-1*TAN(AL)/COS(AZ)-TAN(A)
38 A2=A0*TAN(AZ)
39 A3=-X0*TAN(AL)/COS(AZ)-Z0
40 A4=A0*(Y0+X0*TAN(AZ))
41 XI=(A3+A4)/(A1+A2)
42 F1=0: D=TAN(AZ)
43 IF XI>=X0 THEN F1=1
44 A5=1+D^2+(TAN(AL)/COS(AZ))^2
45 D1=ABS(XI-X0)*SQR(A5)
46 REM  DIST TO 'SOUTH' SLOPE
47 REM  SHADOW PLANE
48 XI=(A3-A4)/(A1-A2)
49 F2=0
50 IF XI>=X0 THEN F2=1
51 D2=ABS(XI-X0)*SQR(A5)
52 REM  DISTANCE TO HORIZON PLANE
53 F3=0: IF AL>=0 THEN F3=1
54 D3=(H0-H)/SIN(ABS(AL)+0.001)
55 REM INTEGRATE ALONG ILLUMINATED
56 REM PORTION OF LINE OF SIGHT
57 D0=100*E
58 IF D1<D0 AND F1=0 THEN D0=D1
59 IF D2<D0 AND F2=0 THEN D0=D2
60 IF D3<D0 AND F3=0 THEN D0=D3
61 IF F1+F2+F3=3 THEN D0=0
62 B0=10^(C*E*D0)   
63 IF F3=0 THEN B0=B0-10^(C*E*D3)
64 IF B0>B9-B THEN B0=B9-B
65 G=S9-S0
66 SK=2.5*LOG(B0+B)/LOG(10)
67 M(I)=INT(0.05+9.9*(SK-S0)/G)
68 NEXT I
69 FOR I9=1 TO H9
70 PRINT RIGHT$(STR$(M(I9)),1);
71 NEXT I9: PRINT
72 NEXT J
73 END
74 REM **************************
75 REM   ASTRONOMICAL COMPUTING
76 REM  SKY & TELESCOPE, APRIL 88
77 REM **************************
